scriptName _SpeedQuestScript extends Quest  


; -- P R O P E R T I E S --------------------------------------------------------------------------

Actor Property PlayerRef  Auto  			; Pointer to player actor

GlobalVariable Property _SpeedMax  Auto  	; Maximum allowed value of SpeedMult
GlobalVariable Property _SpeedMin  Auto		; Level 1 value of SpeedMult
GlobalVariable Property _SpeedRate  Auto  	; Amount to add to SpeedMult each level


; -- E V E N T S ----------------------------------------------------------------------------------

event OnInit()
	; This event fires the first time the mod, and with it the quest, is loaded into the game
	; and each time the quest is restarted by the Increase Level event which is called after the
	; player exists the level up menu.
	UpdateSpeed()

endEvent


; -- F U N C T I O N S ----------------------------------------------------------------------------

function UpdateSpeed()

	; Update the value of SpeedMult based on the players level
	PlayerRef.SetAV( "SpeedMult", GetAdjustedSpeed() )
	
	; This forces changes to SpeedMult to take effect
	PlayerRef.ModAV( "CarryWeight", 1.0 )
	PlayerRef.ModAV( "CarryWeight", -1.0 )
	
	; Stops the quest and wait until the next level up event
	Stop()

endFunction


float function GetAdjustedSpeed()
	
	float afResult = ( ( PlayerRef.GetLevel() - 1 ) * _SpeedRate.GetValue() ) + _SpeedMin.GetValue()
	
	if afResult > _SpeedMax.GetValue()
		afResult = _SpeedMax.GetValue()
		
	endIf
	
	return afResult

endFunction

; -------------------------------------------------------------------------------------------------
